/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thetop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ChangeStateAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.actions.common.RollMoveAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.combat.FlashAtkImgEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CorruptHeart
extends AbstractMonster {
    private static final Logger logger = LogManager.getLogger(CorruptHeart.class.getName());
    public static final String ID = "CorruptHeart";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("CorruptHeart");
    public static final String NAME = CorruptHeart.monsterStrings.NAME;
    public static final String[] MOVES = CorruptHeart.monsterStrings.MOVES;
    public static final String[] DIALOG = CorruptHeart.monsterStrings.DIALOG;
    private static final int MAX_HP = 3333;
    private int beatSpeed = 4;
    private float beatTimer = 4.0f;
    private int points = 0;
    private static final byte START_BEATING = 1;
    private static final byte BLOCK = 2;
    private static final byte ATTACK = 3;
    private static final byte REMOVE_POWER = 4;
    public static final int ECHO_DMG = 16;
    private static final int BLOCK_AMT = 12;

    public CorruptHeart() {
        super(NAME, ID, 3333, 0.0f, 50.0f, 550.0f, 500.0f, "images/monsters/heart.png", -200.0f, -60.0f);
        if (UnlockTracker.isHardModeLocked()) {
            this.currentHealth = CardCrawlGame.playerPref.getInteger("HEART_HP", 3333);
        }
        this.type = AbstractMonster.EnemyType.BOSS;
        this.damage.add(new DamageInfo(this, 16));
    }

    @Override
    public void usePreBattleAction() {
        CardCrawlGame.music.unsilenceBGM();
        AbstractDungeon.scene.fadeOutAmbiance();
        AbstractDungeon.getCurrRoom().playBgmInstantly("BOSS_BOTTOM");
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 1: {
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, "BEAT"));
                break;
            }
            case 2: {
                AbstractDungeon.actionManager.addToBottom(new GainBlockAction(this, this, 12));
                break;
            }
            case 3: {
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.BLUNT_HEAVY));
                break;
            }
            case 4: {
                if (AbstractDungeon.player.powers.isEmpty()) break;
                String toRemove = ((AbstractPower)AbstractDungeon.player.powers.get((int)MathUtils.random((int)0, (int)(AbstractDungeon.player.powers.size() - 1)))).ID;
                AbstractDungeon.actionManager.addToBottom(new RemoveSpecificPowerAction(AbstractDungeon.player, this, toRemove));
            }
        }
        AbstractDungeon.actionManager.addToBottom(new RollMoveAction(this));
    }

    @Override
    protected void getMove(int num) {
        if (num < 50 && !AbstractDungeon.player.powers.isEmpty()) {
            if (!this.lastMove((byte)4)) {
                this.setMove((byte)4, AbstractMonster.Intent.DEBUFF);
            } else {
                this.getMove(MathUtils.random(51, 99));
            }
        } else if (num < 75) {
            if (!this.lastTwoMoves((byte)3)) {
                this.setMove((byte)3, AbstractMonster.Intent.ATTACK, 16);
            } else {
                this.setMove((byte)2, AbstractMonster.Intent.DEFEND, 12);
            }
        } else if (!this.lastTwoMoves((byte)2)) {
            this.setMove((byte)2, AbstractMonster.Intent.DEFEND, 12);
        } else {
            this.setMove((byte)3, AbstractMonster.Intent.ATTACK, 16);
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateBeat();
    }

    private void updateBeat() {
        if (!this.isDying) {
            this.beatTimer -= Gdx.graphics.getDeltaTime();
            if (this.beatTimer < 0.0f) {
                this.beatTimer = this.beatSpeed == 0 ? 0.66f : (float)this.beatSpeed;
                this.beat();
            }
        }
    }

    private void beat() {
        if (AbstractDungeon.player.currentHealth > 0) {
            CardCrawlGame.sound.play("HEART_BEAT");
            AbstractDungeon.effectList.add(new FlashAtkImgEffect(AbstractDungeon.player.hb.cX, AbstractDungeon.player.hb.cY, AbstractGameAction.AttackEffect.BLUNT_HEAVY));
            AbstractDungeon.player.damage(new DamageInfo(this, 1, DamageInfo.DamageType.HP_LOSS));
        }
    }

    public void incrementPoints(int amount) {
        this.points += amount;
        if (this.points > 100) {
            this.points = 0;
            if (this.beatSpeed != 0) {
                --this.beatSpeed;
            }
        }
        logger.info("POINTS: " + this.points);
    }

    @Override
    public void die() {
        super.die();
        this.onBossVictoryLogic();
    }

    @Override
    public void render(SpriteBatch sb) {
        super.render(sb);
        if (this.beatTimer < 1.0f) {
            sb.setColor(this.tint.color);
            sb.draw(this.img, this.drawX - (float)this.img.getWidth() * Settings.scale / 2.0f + this.animX, this.drawY + this.animY + AbstractDungeon.sceneOffsetY, (float)this.img.getWidth() * Settings.scale + this.beatTimer * 30.0f, (float)this.img.getHeight() * Settings.scale + this.beatTimer * 30.0f, 0, 0, this.img.getWidth(), this.img.getHeight(), this.flipHorizontal, this.flipVertical);
            sb.draw(this.img, this.drawX - (float)this.img.getWidth() * Settings.scale / 2.0f + this.animX, this.drawY + this.animY + AbstractDungeon.sceneOffsetY, (float)this.img.getWidth() * Settings.scale + this.beatTimer * 10.0f, (float)this.img.getHeight() * Settings.scale + this.beatTimer * 10.0f, 0, 0, this.img.getWidth(), this.img.getHeight(), this.flipHorizontal, this.flipVertical);
        }
    }
}

